﻿* Encoding: UTF-8.
* Analyse Blue Book mit Jenny.
 
* Alle Wähler.

GET STATA FILE='/Users/maier/Arbeit/Transfer/Publikationen/2010-2019/2019/Blaues Buch/TV-Duell/Daten/2017/2017_aussage_CDU.dta'.

* VARIABLENDEFINITION.
* Sprecher.

compute kandidat=-9.
if (sprech=1) kandidat=1.
if (sprech=2) kandidat=2.
mis val kandidat (-9).

var lab kandidat 'Sprecher'.
val lab kandidat 1 'Merkel' 2 'Schulz' -9 'Moderator, Einspieler etc.'.

compute merkel=-9.
if (sprech=1) merkel=1.
if (sprech=2) merkel=0.
mis val merkel (-9).

var lab merkel 'Sprecher: Merkel'.
val lab merkel 0 'nein' 1 'ja' -9 'kein Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.


compute schulz=-9.
if (sprech=2) schulz=1.
if (sprech=1) schulz=0.
mis val schulz (-9).

var lab schulz 'Sprecher: Schulz'.
val lab schulz 0 'nein' 1 'ja' -9 'kein Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.

* Strategie.

compute strategie=-9.
if ((sprech=1 or sprech=2) and strat=2) strategie=1.
if ((sprech=1 or sprech=2) and strat=1) strategie=2.
if ((sprech=1 or sprech=2) and (strat ne 1 and strat ne 2)) strategie=0.
mis val strategie (-9).

var lab strategie 'Strategie'.
val lab strategie 0 'kein/andere Strategie' 1 'Selbstpräsentation (acclaim)' 2 'Angriff (Attack)' -9  'keine Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.

compute acclaim=-9.
if ((sprech=1 or sprech=2) and strat=2) acclaim=1.
if ((sprech=1 or sprech=2) and strat ne 2) acclaim=0.
mis val acclaim (-9).

var lab acclaim 'Strategie: Selbstpräsentation'.
val lab acclaim 0 'nein' 1 'ja' -9  'kein Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.

compute attack=-9.
if ((sprech=1 or sprech=2) and strat=1) attack=1.
if ((sprech=1 or sprech=2) and strat ne 1) attack=0.
mis val attack (-9).

var lab attack 'Strategie: Angriff'.
val lab attack 0 'nein' 1 'ja' -9  'kein Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.

* ANALYSE.
* (1) Deskriptive Informationen für den Methodenteil.
* 4 "Aussagen" aussortieren, in denen nichts gesagt wurde (und für die es entsprechend zwar RTR-Werte gibt, aber keine weiteren Codierungen).

recode sprech (sysmis=-99).
sel if (sprech ne -99).

* Anzahl Gesamtaussagen, Verteilung Aussagen auf Kandidaten und Moderatoren.

fre sprech.

* Anzahl funktionaler und nicht funktionaler Aussagen.

cro tab tocu by sprech.

* nicht-funktionale Ausagen aussortieren.

sel if (tocu=1).

* Dauer der funktionalen Aussagen.

cro tab dauer by sprech.

* Ausagen mit Laufzeit 0 Sekunden aussortieren.

sel if (dauer gt 0).

* Durchschnittliche Länge der untersuchten Aussagen berechnen.

means tab dauer by kandidat/statistics anova.

* (3) Effekt bestimmen (Tabelle 2).
* Merkel.

temp.
sel if (kandidat=1 and strategie ge 1).
means tab diffton0_schulz by strategie/cells mean stdv min max count/statistics anova.

* Schulz.

temp.
sel if (kandidat=2 and strategie ge 1).
means tab diffton0_schulz by strategie/cells mean stdv min max count/statistics anova.

* Selbstpräsentation.

temp.
sel if (strategie=1).
means tab diffton0_schulz by kandidat/cells mean stdv min max count/statistics anova.

* Angriff.

temp.
sel if (strategie=2).
means tab diffton0_schulz by kandidat/cells mean stdv min max count/statistics anova.


* (4) Effektive, ineffektive und kontraproduktive Aussagen (Tabelle 3).
* Klassifikation der Effekte, Effekte mit dichton0_schulz=0 werden auf 0=keine Wirkung gesetzt.

compute effective=-9.
if (sigdich0=0) effective=0.
if (sigdich0=1 and diffton0_schulz gt 0) effective=1.
if (sigdich0=1 and diffton0_schulz lt 0) effective=-1.
if (diffton0_schulz=0) effective=0.

var lab effective 'Effektivität Aussage'.
val lab effective -1 'nicht intendierte Wirkung' 0 'keine Wirkung' 1 'intendierte Wirkung'.
fre effective.

* Merkel.

temp.
sel if (kandidat=1 and strategie ge 1).
cro tab effective by strategie/cells count col/stat chi.

* Schulz.

temp.
sel if (kandidat=2 and strategie ge 1).
cro tab effective by strategie/cells count col/stat chi.

* Acclaim.

temp.
sel if (strategie=1).
cro tab effective by kandidat/cells count col/stat chi.

* Angriff.

temp.
sel if (strategie=2).
cro tab effective by kandidat/cells count col/stat chi.



